<?php

namespace App\Services\Commons\Git;

use App\Services\CommandService;
use Illuminate\Contracts\Process\ProcessResult;
use Illuminate\Support\Traits\Conditionable;

final class GitRemoteService extends CommandService
{
    use Conditionable;

    public function location(string $location): self
    {
        $this->process_path = $location;

        return $this;
    }

    public function add(string $name, string $url): ProcessResult
    {
        $command = "LANG=en_GB git remote add {$name} {$url}";

        return $this->execute($command);
    }

    public function set(string $name, string $url): ProcessResult
    {
        $command = "LANG=en_GB git remote set-url {$name} {$url}";

        return $this->execute($command);
    }

    public function remove(string $name): ProcessResult
    {
        $command = "LANG=en_GB git remote remove {$name}";

        return $this->execute($command);
    }
}
