<?php

namespace App\Services\Commons\Git;

use App\Services\CommandService;
use Illuminate\Contracts\Process\ProcessResult;
use Illuminate\Support\Traits\Conditionable;

final class GitPushService extends CommandService
{
    use Conditionable;

    private bool $set_upstream = false;

    public function location(string $location): self
    {
        $this->process_path = $location;

        return $this;
    }

    public function setUpstream(): self
    {
        $this->set_upstream = true;

        return $this;
    }

    public function push(string $remote, string $branch): ProcessResult
    {
        $command = "LANG=en_GB git push";

        if ($this->set_upstream) {
            $command .= " --set-upstream";
        }

        $command .= " {$remote} {$branch}";

        return $this->execute($command);
    }
}
