<?php

namespace App\Services\Commons\Git;

use App\Services\CommandService;
use Illuminate\Contracts\Process\ProcessResult;
use Illuminate\Support\Traits\Conditionable;

final class GitCloneService extends CommandService
{
    use Conditionable;

    private string $repository = '';

    private string $branch = 'master';

    public function repository(string $repository): self
    {
        $this->repository = $repository;

        return $this;
    }

    public function branch(string $branch): self
    {
        $this->branch = $branch;

        return $this;
    }

    public function to(string $location): ProcessResult
    {
        $command = "LANG=en_GB git clone --branch={$this->branch} {$this->repository} {$location}";

        return $this->execute($command);
    }
}
