<?php

namespace App\Services\Commons\Git;

use App\Services\CommandService;
use Illuminate\Contracts\Process\ProcessResult;
use Illuminate\Support\Traits\Conditionable;

final class GitCheckoutService extends CommandService
{
    use Conditionable;

    private bool $create = false;

    public function location(string $location): self
    {
        $this->process_path = $location;

        return $this;
    }

    public function create(): self
    {
        $this->create = true;

        return $this;
    }

    public function checkout(string $branch): ProcessResult
    {
        $command = "LANG=en_GB git checkout";

        if ($this->create) {
            $command .= " -b";
        }

        $command .= " {$branch}";

        return $this->execute($command);
    }
}
