<?php

namespace App\Services\Commons\Git;

use App\Services\CommandService;
use Illuminate\Contracts\Process\ProcessResult;
use Illuminate\Support\Traits\Conditionable;

final class GitAddService extends CommandService
{
    use Conditionable;

    public function location(string $location): self
    {
        $this->process_path = $location;

        return $this;
    }

    public function add(string ...$files): ProcessResult
    {
        return $this->execute('LANG=en_GB git add ' . implode(' ', $files));
    }
}
