<?php

namespace App\Services\Commons;

use App\Services\CommandService;
use Illuminate\Contracts\Process\ProcessResult;

final class ArtisanService extends CommandService
{
    public function location(string $location): self
    {
        $this->process_path = $location;

        return $this;
    }

    public function command(string $command): ProcessResult
    {
        $command = str('php artisan '.$command)->wrap('"')->start('su webuser -c ');

        return docker()->compose()->service('dev')->location($this->process_path)->interactive()->exec($command);
    }
}
