<?php

namespace App\Services;

use Illuminate\Contracts\Process\ProcessResult;
use Illuminate\Support\Facades\Process;
use Illuminate\Support\Traits\Conditionable;

abstract class CommandService
{
    use Conditionable;

    protected bool $process_tty = false;

    protected false|string $process_path = false;

    protected function __construct()
    {
    }

    protected function execute(string $command): ProcessResult
    {
        $result = Process::forever()
            ->when($this->process_tty, fn (Process $process) => $process->tty())
            ->when($this->process_path, fn (Process $process) => $process->path($this->process_path))
            ->run($command);

        output()->debug($result);

        return $result;
    }

    public static function new(): static
    {
        return new static();
    }
}
