<?php

namespace App\Commands\Tools;

use App\Services\DockerService;
use App\Traits\DirectoryPathfinder;
use Illuminate\Support\Facades\File;
use LaravelZero\Framework\Commands\Command;

class PhpStan extends Command
{
    use DirectoryPathfinder;

    /**
     * The signature of the command.
     *
     * @var string
     */
    protected $signature = 'phpstan';

    /**
     * The description of the command.
     *
     * @var string
     */
    protected $description = 'Run PHPStan on current directory';

    /**
     * Execute the console command.
     */
    public function handle(): int
    {
        if (! $this->isPackageDirectory()) {
            output()->kill('PHPSTAN', 'You are not inside a package directory!');
        }

        $directory = File::exists(getcwd().'/app') ? 'app' : 'src';

        $result = DockerService::run()
            ->remove()
            ->tty()
            ->volume(getcwd(), '/app')
            ->image('ghcr.io/phpstan/phpstan:latest-php8.0')
            ->command("analyse $directory/ config/ database/ --level 8")
            ->execute();

        output()->debug($result);

        return $result->exitCode();
    }
}
