<?php

namespace App\Commands\Tools;

use App\Services\DockerService;
use App\Traits\DirectoryPathfinder;
use LaravelZero\Framework\Commands\Command;

class CsFixer extends Command
{
    use DirectoryPathfinder;

    /**
     * The signature of the command.
     *
     * @var string
     */
    protected $signature = 'cs-fixer';

    /**
     * The description of the command.
     *
     * @var string
     */
    protected $description = 'Run PHP-CS-Fixer on current directory';

    /**
     * Execute the console command.
     */
    public function handle(): int
    {
        if (! $this->isPackageDirectory()) {
            output()->kill('CS-FIXER', 'You are not inside a package directory!');
        }

        $result = DockerService::run()
            ->remove()
            ->tty()
            ->volume(getcwd(), '/data')
            ->image('cytopia/php-cs-fixer:latest-php8.0')
            ->command('fix --using-cache=no --verbose --diff --config php-cs-fixer.dist.php')
            ->execute();

        output()->debug($result);

        return $result->exitCode();
    }
}
