<?php

namespace App\Commands\Scripts;

use App\Services\GitService;
use App\Traits\DirectoryPathfinder;
use LaravelZero\Framework\Commands\Command;

class ScriptUpdate extends Command
{
    use DirectoryPathfinder;

    /**
     * The signature of the command.
     *
     * @var string
     */
    protected $signature = 'script:update';

    /**
     * The description of the command.
     *
     * @var string
     */
    protected $description = 'Update Inside CLI Zero script';

    /**
     * Execute the console command.
     */
    public function handle(): int
    {
        output()->success('SCRIPT', 'Inside CLI Zero script updated!');
        GitService::pull($this->createPath('$HOME', '.inside'));

        return 0;
    }
}
