<?php

namespace App\Commands\Project\Workers;

use App\Actions\Project\Workers\StopWorkerAction;
use App\Traits\DirectoryPathfinder;
use LaravelZero\Framework\Commands\Command;

class WorkersStop extends Command
{
    use DirectoryPathfinder;

    /**
     * The signature of the command.
     *
     * @var string
     */
    protected $signature = 'workers:stop';

    /**
     * The description of the command.
     *
     * @var string
     */
    protected $description = 'Stop workers';

    /**
     * Execute the console command.
     */
    public function handle(): int
    {
        if (! $this->isProjectDirectory()) {
            output()->kill('WORKER', 'You are not inside a project directory!');
        }

        $action = new StopWorkerAction();

        return collect([
            $action->stop('queue-indexation', $this->projectDirectory())->exitCode(),
            $action->stop('queue-images', $this->projectDirectory())->exitCode(),
            $action->stop('queue-default', $this->projectDirectory())->exitCode(),
            $action->stop('queue-lts', $this->projectDirectory())->exitCode(),
        ])->filter()->isNotEmpty();
    }
}
