<?php

namespace App\Commands\Project\Workers;

use App\Actions\Project\Workers\StartWorkerAction;
use App\Traits\DirectoryPathfinder;
use LaravelZero\Framework\Commands\Command;

class WorkersStart extends Command
{
    use DirectoryPathfinder;

    /**
     * The signature of the command.
     *
     * @var string
     */
    protected $signature = 'workers:start';

    /**
     * The description of the command.
     *
     * @var string
     */
    protected $description = 'Start workers';

    /**
     * Execute the console command.
     */
    public function handle(): int
    {
        if (! $this->isProjectDirectory()) {
            output()->kill('WORKER', 'You are not inside a project directory!');
        }

        $action = new StartWorkerAction();

        return collect([
            $action->start('queue-indexation', $this->projectDirectory())->exitCode(),
            $action->start('queue-images', $this->projectDirectory())->exitCode(),
            $action->start('queue-default', $this->projectDirectory())->exitCode(),
            $action->start('queue-lts', $this->projectDirectory())->exitCode(),
        ])->filter()->isNotEmpty();
    }
}
