<?php

namespace App\Commands\Project\Workers;

use App\Actions\Project\Workers\StartWorkerAction;
use App\Actions\Project\Workers\StopWorkerAction;
use App\Traits\DirectoryPathfinder;
use LaravelZero\Framework\Commands\Command;

class WorkersRestart extends Command
{
    use DirectoryPathfinder;

    /**
     * The signature of the command.
     *
     * @var string
     */
    protected $signature = 'workers:restart';

    /**
     * The description of the command.
     *
     * @var string
     */
    protected $description = 'Restart workers';

    /**
     * Execute the console command.
     */
    public function handle(): int
    {
        if (! $this->isProjectDirectory()) {
            output()->kill('WORKER', 'You are not inside a project directory!');
        }

        $stopAction = new StopWorkerAction();
        $startAction = new StartWorkerAction();

        return collect([
            $stopAction->stop('queue-indexation', $this->projectDirectory())->exitCode(),
            $stopAction->stop('queue-images', $this->projectDirectory())->exitCode(),
            $stopAction->stop('queue-default', $this->projectDirectory())->exitCode(),
            $stopAction->stop('queue-lts', $this->projectDirectory())->exitCode(),
            $startAction->start('queue-indexation', $this->projectDirectory())->exitCode(),
            $startAction->start('queue-images', $this->projectDirectory())->exitCode(),
            $startAction->start('queue-default', $this->projectDirectory())->exitCode(),
            $startAction->start('queue-lts', $this->projectDirectory())->exitCode(),
        ])->filter()->isNotEmpty();
    }
}
