<?php

namespace App\Commands\Project\Workers;

use App\Actions\Project\Workers\LogsWorkersAction;
use App\Traits\DirectoryPathfinder;
use LaravelZero\Framework\Commands\Command;

class WorkersLogs extends Command
{
    use DirectoryPathfinder;

    /**
     * The signature of the command.
     *
     * @var string
     */
    protected $signature = 'workers:logs {n=20 : Number of lines to show}';

    /**
     * The description of the command.
     *
     * @var string
     */
    protected $description = 'Logs workers';

    /**
     * Execute the console command.
     */
    public function handle(): int
    {
        if (! $this->isProjectDirectory()) {
            output()->kill('WORKER', 'You are not inside a project directory!');
        }

        if (! is_numeric($this->argument('n'))) {
            output()->kill('WORKER', 'The number of lines must be an integer!');
        }

        $action = new LogsWorkersAction();

        return $action->logs(
            names: ['queue-indexation', 'queue-images', 'queue-default', 'queue-lts'],
            directory: $this->projectDirectory(),
            tail: (int) $this->argument('n')
        )->exitCode();
    }
}
