<?php

namespace App\Commands\Project\Tasks;

use App\Actions\Project\Tasks\RunDrushAction;
use App\Traits\DirectoryPathfinder;
use LaravelZero\Framework\Commands\Command;

class Drush extends Command
{
    use DirectoryPathfinder;

    /**
     * The signature of the command.
     *
     * @var string
     */
    protected $signature = 'drush {task?*}';

    /**
     * The description of the command.
     *
     * @var string
     */
    protected $description = 'Run a Drush command';

    public function __construct()
    {
        parent::__construct();
        $this->ignoreValidationErrors();
    }

    /**
     * Execute the console command.
     */
    public function handle(): int
    {
        if (! $this->isProjectDirectory()) {
            output()->kill('DRUSH', 'You are not inside a project directory!');
        }

        $action = new RunDrushAction();

        $command = str($this->input->__toString())->after($this->input->getFirstArgument())->trim()->toString();

        return $action->run($command, $this->projectDirectory())->exitCode();
    }
}
