<?php

namespace App\Commands\Project\Tasks;

use App\Actions\Project\Tasks\RunComposerAction;
use App\Traits\DirectoryPathfinder;
use LaravelZero\Framework\Commands\Command;

class Composer extends Command
{
    use DirectoryPathfinder;

    /**
     * The signature of the command.
     *
     * @var string
     */
    protected $signature = 'composer {task?*}';

    /**
     * The description of the command.
     *
     * @var string
     */
    protected $description = 'Run a Composer command';

    public function __construct()
    {
        parent::__construct();
        $this->ignoreValidationErrors();
    }

    /**
     * Execute the console command.
     */
    public function handle(): int
    {
        if (! $this->isProjectDirectory()) {
            output()->kill('COMPOSER', 'You are not inside a project directory!');
        }

        $action = new RunComposerAction();

        $dependency = $this->isPackageDirectory()
            ? $this->packageFromAppDirectory()
            : $this->appDirectory();

        $command = str($this->input->__toString())->after($this->input->getFirstArgument())->trim()->toString();

        return $action->run($command, $this->projectDirectory(), $dependency)->exitCode();
    }
}
