<?php

namespace App\Commands\Project\Storage;

use App\Actions\Project\Storage\DownloadStorageAction;
use App\Traits\DirectoryPathfinder;
use LaravelZero\Framework\Commands\Command;

class StorageDownload extends Command
{
    use DirectoryPathfinder;

    /**
     * The signature of the command.
     *
     * @var string
     */
    protected $signature = 'storage:download {--server=dev : The server to download from}';

    /**
     * The description of the command.
     *
     * @var string
     */
    protected $description = 'Download the storage directory from the server';

    public function handle(): int
    {
        if (! $this->isProjectDirectory()) {
            output()->kill('CP', 'You are not inside a project directory!');
        }

        if (collect(config('inside.servers'))->keys()->doesntContain($this->option('server'))) {
            output()->kill('CP', 'The server does not exist!');
        }

        $action = new DownloadStorageAction();

        return $action->download(
            to: $this->projectDirectory(),
            host: config("inside.servers.{$this->option('server')}.host"),
            username: config("inside.servers.{$this->option('server')}.username")
        )->exitCode();
    }
}
