<?php

namespace App\Commands\Project\Status;

use App\Actions\Project\Status\StopProjectAction;
use App\Traits\DirectoryPathfinder;
use LaravelZero\Framework\Commands\Command;

class ProjectStop extends Command
{
    use DirectoryPathfinder;

    /**
     * The signature of the command.
     *
     * @var string
     */
    protected $signature = 'stop';

    /**
     * The description of the command.
     *
     * @var string
     */
    protected $description = 'Stop the project';

    /**
     * Execute the console command.
     */
    public function handle(): int
    {
        if (! $this->isProjectDirectory()) {
            output()->kill('PROJECT', 'You are not inside a project directory!');
        }

        $action = new StopProjectAction();

        return $action->stop($this->projectDirectory())->exitCode();
    }
}
