<?php

namespace App\Commands\Project\Status;

use App\Actions\Project\Status\StartProjectAction;
use App\Traits\DirectoryPathfinder;
use LaravelZero\Framework\Commands\Command;

class ProjectStart extends Command
{
    use DirectoryPathfinder;

    /**
     * The signature of the command.
     *
     * @var string
     */
    protected $signature = 'start';

    /**
     * The description of the command.
     *
     * @var string
     */
    protected $description = 'Start the project';

    /**
     * Execute the console command.
     */
    public function handle(): int
    {
        if (! $this->isProjectDirectory()) {
            output()->kill('PROJECT', 'You are not inside a project directory!');
        }

        $action = new StartProjectAction();

        return $action->start($this->projectDirectory())->exitCode();
    }
}
