<?php

namespace App\Commands\Project\Status;

use App\Actions\Project\Status\StartProjectAction;
use App\Actions\Project\Status\StopProjectAction;
use App\Traits\DirectoryPathfinder;
use LaravelZero\Framework\Commands\Command;

class ProjectRestart extends Command
{
    use DirectoryPathfinder;

    /**
     * The signature of the command.
     *
     * @var string
     */
    protected $signature = 'restart';

    /**
     * The description of the command.
     *
     * @var string
     */
    protected $description = 'Restart the project';

    /**
     * Execute the console command.
     */
    public function handle(): int
    {
        if (! $this->isProjectDirectory()) {
            output()->kill('PROJECT', 'You are not inside a project directory!');
        }

        return collect([
            (new StopProjectAction())->stop($this->projectDirectory())->exitCode(),
            (new StartProjectAction())->start($this->projectDirectory())->exitCode(),
        ])->filter()->isNotEmpty();
    }
}
