<?php

namespace App\Commands\Project\Status;

use App\Traits\DirectoryPathfinder;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\Process;
use LaravelZero\Framework\Commands\Command;
use Symfony\Component\Finder\SplFileInfo;

class ProjectLogs extends Command
{
    use DirectoryPathfinder;

    /**
     * The signature of the command.
     *
     * @var string
     */
    protected $signature = 'logs  {n=20 : Number of lines to show}';

    /**
     * The description of the command.
     *
     * @var string
     */
    protected $description = 'Show project logs';

    /**
     * Execute the console command.
     */
    public function handle(): void
    {
        if (! $this->isProjectDirectory()) {
            output()->kill('PROJECT', 'You are not inside a project directory!');
        }

        if (! is_numeric($this->argument('n'))) {
            output()->kill('WORKER', 'The number of lines must be an integer!');
        }

        if (! File::exists($this->createPath($this->projectDirectory(), 'storage', 'logs'))) {
            output()->kill('PROJECT', 'The logs directory does not exist!');
        }

        $file = collect(File::files($this->createPath($this->projectDirectory(), 'storage', 'logs')))
            ->map(fn (SplFileInfo $file) => ['relativePath' => $file->getRealPath(), 'date' => str($file->getFilenameWithoutExtension())->beforeLast('-')->toDate('Y-m-d')])
            ->sortByDesc('date')
            ->first();

        $command = collect([
            'tail',
            '-n',
            $this->argument('n'),
            '-f',
            $file['relativePath'],
            '|',
            'sed',
            '-e \'s/\(.*DEBUG.*\)/\x1B[36m\1\x1B[39m/\'',
            '-e \'s/\(.*INFO.*\)/\x1B[32m\1\x1B[39m/\'',
            '-e \'s/\(.*ERROR.*\)/\x1B[31m\1\x1B[39m/\'',
        ])->join(' ');

        $result = Process::forever()->tty()->run($command);
        output()->debug($result);
    }
}
