<?php

namespace App\Commands\Project\Status;

use App\Traits\DirectoryPathfinder;
use LaravelZero\Framework\Commands\Command;

class ProjectLinks extends Command
{
    use DirectoryPathfinder;

    /**
     * The signature of the command.
     *
     * @var string
     */
    protected $signature = 'links';

    /**
     * The description of the command.
     *
     * @var string
     */
    protected $description = 'Utils links for project';

    /**
     * Execute the console command.
     */
    public function handle(): void
    {
        if (! $this->isProjectDirectory()) {
            output()->kill('PROJECT', 'You are not inside a project directory!');
        }

        output()->success('WEB', "https://{$this->appCode()}.docker.localhost");
        output()->success('ADMINER', "https://{$this->appCode()}-adminer.docker.localhost");
        output()->success('MAIL', "https://{$this->appCode()}-mail.docker.localhost");
        output()->success('SOLR', "https://{$this->appCode()}-solr.docker.localhost");
    }
}
