<?php

namespace App\Commands\Project\Database;

use App\Actions\Project\Database\CreateDatabaseAction;
use App\Actions\Project\Database\DeleteDatabaseAction;
use App\Actions\Project\Database\ImportDatabaseAction;
use App\Services\DockerService;
use App\Services\MysqlService;
use App\Traits\DirectoryPathfinder;
use LaravelZero\Framework\Commands\Command;

class ImportDatabase extends Command
{
    use DirectoryPathfinder;

    /**
     * The signature of the command.
     *
     * @var string
     */
    protected $signature = 'database:import {file}';

    /**
     * The description of the command.
     *
     * @var string
     */
    protected $description = 'Import the database from sql file';

    public function handle(): int
    {
        $file = $this->argument('file');

        if (! $this->isProjectDirectory()) {
            output()->kill('DATABASE', 'You are not inside a project directory!');
        }

        (new DeleteDatabaseAction())->delete($this->projectDirectory());
        (new CreateDatabaseAction())->create($this->projectDirectory());

        $command = MysqlService::boot()->username('inside')->password('inside')->database('inside')->directory($file)->import();
        $result = DockerService::compose()->location($this->projectDirectory())->container('database')->interactive()->exec($command);
        output()->debug($result);

        match (true) {
            $result->successful() => output()->success('DATABASE', 'Database imported!'),
            $result->failed() => output()->kill('DATABASE', 'Database failed to import!'),
        };

        return $result->exitCode();
    }
}
