<?php

namespace App\Commands\Project\Database;

use App\Traits\DirectoryPathfinder;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\Storage;
use LaravelZero\Framework\Commands\Command;

class DownloadDatabase extends Command
{
    use DirectoryPathfinder;

    /**
     * The signature of the command.
     *
     * @var string
     */
    protected $signature = 'database:download {project-code}';

    /**
     * The description of the command.
     *
     * @var string
     */
    protected $description = 'Download the database from backup bucket';

    public function handle(): int
    {
        $code = $this->argument('project-code');
        $current = now()->format('Y-m-d');

        File::put('database.tar.zst', Storage::disk('backup')->get("/{$code}/pp/{$current}/database.tar.zst"));

        $result = tar()->zstd()->filename('database.tar.zst')->extract();

        match (true) {
            $result->successful() => output()->success('Database', "Database for {$code} has been downloaded on the current path!"),
            $result->failed() => output()->kill('Database', 'Failed to download the database!'),
        };

        return File::delete('database.tar.zst');
    }
}
