<?php

namespace App\Actions\Traefik;

use App\Services\TraefikService;
use Illuminate\Contracts\Process\ProcessResult;

class StopTraefikAction
{
    public function stop(): ProcessResult
    {
        $result = TraefikService::stop();
        output()->debug($result);

        match (true) {
            $result->seeInErrorOutput('No such container') => output()->warning('TRAEFIK', 'Traefik is already stopped!'),
            $result->successful() => output()->success('TRAEFIK', 'Traefik is stopped!'),
            $result->failed() => output()->error('TRAEFIK', 'Traefik failed to stop!'),
        };

        return $result;
    }
}
