<?php

namespace App\Actions\Traefik;

use App\Services\TraefikService;
use Illuminate\Contracts\Process\ProcessResult;

class StartTraefikAction
{
    public function start(): ProcessResult
    {
        $result = TraefikService::start();
        output()->debug($result);

        match (true) {
            $result->seeInErrorOutput('You have to remove (or rename) that container to be able to reuse that name') => output()->warning('TRAEFIK', 'Traefik is already running!'),
            $result->successful() => output()->success('TRAEFIK', 'Traefik is running!'),
            $result->failed() => output()->error('TRAEFIK', 'Traefik failed to start!'),
        };

        return $result;
    }
}
