<?php

namespace App\Actions\Project\Workers;

use App\Services\DockerService;
use Illuminate\Contracts\Process\ProcessResult;

class StopWorkerAction
{
    public function stop(string $name, string $directory): ProcessResult
    {
        $result = DockerService::compose()->location($directory)->container($name)->down();
        output()->debug($result);

        match (true) {
            $result->successful() => output()->success('WORKER', str($name)->ucfirst()->finish(' stopped!')),
            $result->failed() => output()->kill('WORKER', str($name)->ucfirst()->finish(' failed to stop!')),
        };

        return $result;
    }
}
