<?php

namespace App\Actions\Project\Workers;

use App\Services\DockerService;
use Illuminate\Contracts\Process\ProcessResult;

class StartWorkerAction
{
    public function start(string $name, string $directory): ProcessResult
    {
        $result = DockerService::compose()->location($directory)->container($name)->detach()->up();
        output()->debug($result);

        match (true) {
            $result->successful() => output()->success('WORKER', str($name)->ucfirst()->finish(' started!')),
            $result->failed() => output()->kill('WORKER', str($name)->ucfirst()->finish(' failed to start!')),
        };

        return $result;
    }
}
