<?php

namespace App\Actions\Project\Workers;

use App\Services\DockerService;
use Illuminate\Contracts\Process\ProcessResult;

class LogsWorkersAction
{
    public function logs(array $names, string $directory, int $tail = 20): ProcessResult
    {
        $result = DockerService::compose()->location($directory)->tty()->follow()->tail($tail)->logs($names);
        output()->debug($result);

        return $result;
    }
}
