<?php

namespace App\Actions\Project\Tasks;

use App\Services\DockerService;
use App\Services\DrushService;
use Illuminate\Contracts\Process\ProcessResult;

class RunDrushAction
{
    public function run(string $task, string $directory): ProcessResult
    {
        $command = DrushService::boot()->execute($task);
        $result = DockerService::compose()->location($directory)->tty()->container('dev')->exec($command);
        output()->debug($result);

        return $result;
    }
}
