<?php

namespace App\Actions\Project\Tasks;

use App\Services\ComposerService;
use App\Services\DockerModules\DockerCompose;
use App\Services\DockerService;
use Illuminate\Contracts\Process\ProcessResult;

class RunComposerAction
{
    public function run(string $task, string $directory, false|string $dependency = false): ProcessResult
    {
        $containerRunning = str(DockerService::compose()->location($directory)->ps()->output())->explode("\n")->contains('dev');

        $command = ComposerService::boot()->when($dependency, fn (ComposerService $composer) => $composer->dependency($dependency))->execute($task);
        $result = DockerService::compose()->location($directory)->tty()->container('dev')->when($containerRunning, fn (DockerCompose $docker) => $docker->exec($command), fn (DockerCompose $docker) => $docker->remove()->run($command));
        output()->debug($result);

        return $result;
    }
}
