<?php

namespace App\Actions\Project\Tasks;

use App\Services\ArtisanService;
use App\Services\DockerService;
use Illuminate\Contracts\Process\ProcessResult;

class RunArtisanAction
{
    public function run(string $task, string $directory): ProcessResult
    {
        $command = ArtisanService::boot()->artisan($task);
        $result = DockerService::compose()->location($directory)->tty()->container('dev')->exec($command);
        output()->debug($result);

        return $result;
    }
}
