<?php

namespace App\Actions\Project\Storage;

use App\Services\CpService;
use Illuminate\Contracts\Process\ProcessResult;

class DownloadStorageAction
{
    public function download(string $to, false|string $from = false, false|string $host = false, false|string $username = false): ProcessResult
    {
        $code = basename($to);

        $result = CpService::boot()
            ->when($host && $username, fn (CpService $service) => $service->remote($host, $username)->from("/srv/{$code}/public_html/storage/app/*"))
            ->unless($host && $username, fn (CpService $service) => $service->from("{$from}/storage/app/*"))
            ->to("{$to}/storage/app")
            ->copy();

        output()->debug($result);

        return $result;
    }
}
