<?php

namespace App\Actions\Project\Status;

use App\Services\DockerService;
use Illuminate\Contracts\Process\ProcessResult;

class StopProjectAction
{
    public function stop(string $directory): ProcessResult
    {
        $result = DockerService::compose()->location($directory)->tty()->down();
        output()->debug($result);

        match (true) {
            $result->successful() => output()->success('PROJECT', 'Project stopped!'),
            $result->failed() => output()->kill('PROJECT', 'Project failed to stop!'),
        };

        return $result;
    }
}
