<?php

namespace App\Actions\Project\Status;

use App\Services\DockerService;
use Illuminate\Contracts\Process\ProcessResult;

class StartProjectAction
{
    public function start(string $directory): ProcessResult
    {
        $result = tap(DockerService::compose()->location($directory)->tty()->detach()->up(), fn () => sleep(1));
        output()->debug($result);

        match (true) {
            $result->successful() => output()->success('PROJECT', 'Project started!'),
            $result->failed() => output()->kill('PROJECT', 'Project failed to start!'),
        };

        return $result;
    }
}
