<?php

namespace App\Actions\Project\Status;

use App\Services\DockerService;
use Illuminate\Contracts\Process\ProcessResult;

class PullProjectAction
{
    public function pull(string $directory): ProcessResult
    {
        $result = DockerService::compose()->location($directory)->tty()->pull();
        output()->debug($result);

        match (true) {
            $result->successful() => output()->success('PROJECT', 'Image pulled!'),
            $result->failed() => output()->kill('PROJECT', 'Image failed to pull!'),
        };

        return $result;
    }
}
