<?php

namespace App\Actions\Project\Database;

use App\Services\DockerService;
use App\Services\MysqlService;
use Illuminate\Contracts\Process\ProcessResult;

class ImportDatabaseAction
{
    public function import(string $directory, false|string $host = false, false|string $user = false, false|string $databaseUser = false, false|string $databasePassword = false): ProcessResult
    {
        $code = basename($directory);

        if ($host && $user && $databaseUser && $databasePassword) {
            $result = MysqlService::boot()
                ->remote($host, $user)
                ->username($databaseUser)
                ->password($databasePassword)
                ->database($code)
                ->directory("/tmp/{$code}.sql")
                ->dump();

            output()->debug($result);

            match (true) {
                $result->successful() => output()->success('DATABASE', 'Database dumped from remote server!'),
                $result->failed() => output()->kill('DATABASE', 'Database failed to dump!'),
            };
        }

        $command = MysqlService::boot()->username('inside')->password('inside')->database('inside')->directory("/tmp/{$code}.sql")->import();
        $result = DockerService::compose()->location($directory)->container('database')->interactive()->exec($command);
        output()->debug($result);

        match (true) {
            $result->successful() => output()->success('DATABASE', 'Database imported!'),
            $result->failed() => output()->kill('DATABASE', 'Database failed to import!'),
        };

        return $result;
    }
}
