<?php

namespace App\Actions\Project\Database;

use App\Services\DockerService;
use Illuminate\Contracts\Process\ProcessResult;

class DeleteDatabaseAction
{
    public function delete(string $directory): ProcessResult
    {
        $result = DockerService::compose()->location($directory)->container('database')->downWithVolumes();
        output()->debug($result);

        match (true) {
            $result->successful() => output()->success('DATABASE', 'Cleaned database!'),
            $result->failed() => output()->kill('DATABASE', 'Failed to clean database!'),
        };

        return $result;
    }
}
