<?php

namespace App\Actions\Project\Database;

use App\Services\DockerService;
use App\Services\MysqlService;
use Illuminate\Contracts\Process\ProcessResult;

class CreateDatabaseAction
{
    public function create(string $directory): ProcessResult
    {
        $result = DockerService::compose()->location($directory)->container('database')->detach()->up();
        output()->debug($result);

        match (true) {
            $result->successful() => output()->success('DATABASE', 'Database created!'),
            $result->failed() => output()->kill('DATABASE', 'Database failed to create!'),
        };

        $command = MysqlService::boot()->host('127.0.0.1')->username('inside')->password('inside')->ping();
        do {
            $result = tap(DockerService::compose()->location($directory)->container('database')->interactive()->exec($command), fn () => sleep(1));
        } while ($result->seeInErrorOutput('Can\'t connect to MySQL server'));

        output()->success('DATABASE', 'Database is ready to handle connection!');

        return $result;
    }
}
