
# Inside CLI Zero

## 🏞️ Présentation

Inside CLI Zero est un outil en ligne de commande permettant de gérer les projets de l'agence.

Il permet de développer en local via docker et est compatible avec Linux, Mac et Windows (WSL2).

## 🧰 Pré-requis

Pour utiliser Inside CLI Zero, il faut avoir installé les outils suivants :

* [Docker](https://docs.docker.com/get-docker/) via [Docker Desktop](https://www.docker.com/products/docker-desktop) pour WSL2 ou [Orbstack](https://orbstack.dev/) pour Mac
* [Nvm](https://github.com/nvm-sh/nvm) puis installer la version 20.7.0
* [Pyenv](https://github.com/pyenv/pyenv) puis installer la version 3.11.6

## ⚙️ Installation
### Linux

```bash
sudo add-apt-repository ppa:ondrej/php # Press enter when prompted.
sudo apt update
sudo apt install php8.2-cli php8.2-xml

git clone git@bitbucket.org:maecia/inside-cli-zero.git $HOME/.inside
cp $HOME/.inside/.env.example $HOME/.inside/builds/.env

echo 'export PUID=$(id -u)' >> $HOME/.zshrc
echo 'export PGID=$(id -g)' >> $HOME/.zshrc
echo 'alias inside="php $HOME/.inside/builds/inside"' >> $HOME/.zshrc
```

Modifier le fichier `$HOME/.inside/builds/.env` pour y mettre les bonnes valeurs puis relancer le terminal.


### Mac

```bash
brew install php@8.2 mkcert
brew link php@8.2

git clone git@bitbucket.org:maecia/inside-cli-zero.git $HOME/.inside
cp $HOME/.inside/.env.example $HOME/.inside/builds/.env
mkcert -cert-file $HOME/.inside/certs/local-cert.pem -key-file $HOME/.inside/certs/local-key.pem "docker.localhost" "*.docker.localhost"
mkcert -install

echo 'export PUID=$(id -u)' >> $HOME/.zshrc
echo 'export PGID=$(id -g)' >> $HOME/.zshrc
echo 'alias inside="php $HOME/.inside/builds/inside"' >> $HOME/.zshrc
```

Modifier le fichier `$HOME/.inside/builds/.env` pour y mettre les bonnes valeurs puis relancer le terminal.

### Windows (WSL2)

Côté Powershell (Administrateur)
```powershell
cd
choco install mkcert
mkcert -cert-file local-cert.pem -key-file local-key.pem "docker.localhost" "*.docker.localhost"
mkcert -install

```

Côté WSL2
```bash
sudo add-apt-repository ppa:ondrej/php # Press enter when prompted.
sudo apt update
sudo apt install php8.2-cli php8.2-xml

git clone git@bitbucket.org:maecia/inside-cli-zero.git $HOME/.inside
cp $HOME/.inside/.env.example $HOME/.inside/builds/.env
cp /mnt/c/Users/$(whoami)/*.pem $HOME/.inside/certs/

echo 'export PUID=$(id -u)' >> $HOME/.zshrc
echo 'export PGID=$(id -g)' >> $HOME/.zshrc
echo 'alias inside="php $HOME/.inside/builds/inside"' >> $HOME/.zshrc
```

Modifier le fichier `$HOME/.inside/builds/.env` pour y mettre les bonnes valeurs puis relancer le terminal.
