# Inside Authentication SAML

Authenticate in Inside system using SAML.

SAML Authentication system provide several routes:

|  URL                 |  explanation                      |
|----------------------|-----------------------------------|
| mysite/saml/login    | provide access to saml login form |
| mysite/saml/logout   | logout saml and inside            |
| mysite/saml/metadata | provide metadata as xml           |

Config is set and commented in
config/saml2.php

## Generating certificate and key

Use this command to generate the certificate and private key files (in a directory outside of the website root):

`openssl req -new -x509 -days 3652 -nodes -out saml.crt -keyout saml.key`

The files must then be put in .env:

```dotenv
SAML2_SP_x509="file:///path/to/saml.crt"
SAML2_SP_PRIVATEKEY="file:///path/to/saml.key"
```
