<?php
$idp_host = env('SAML2_IDP_HOST', 'http://localhost:8000/simplesaml');
$certPath = cms_base_path('certs/saml.crt');
$keyPath  = cms_base_path('certs/saml.key');

$cert = '';
$key  = '';

if (file_exists($certPath)) {
    $certContent = file_get_contents($certPath);
    $cert = is_string($certContent) ? trim($certContent) : '';
}

if (file_exists($keyPath)) {
    $keyContent = file_get_contents($keyPath);
    $key = is_string($keyContent) ? trim($keyContent) : '';
}

return $settings = [
    'routesPrefix' => env('SAML2_ROUTE_PREFIX', '/saml'),
    'retrieveParametersFromServer' => env('SAML2_RETRIEVE_PARAMETERS_FROM_SERVER', false),
    'logoutRoute' => '/logout',
    'loginRoute' => '/external-login',
    'errorRoute' => '/',
    'binding' => [
        'name_id_method' => env('SAML2_NAMEID_METHOD', 'getUserId'),
        'name_id_custom_attribute' => env('SAML2_NAMEID_CUSTOM_ATTRIBUTE', null),
        'discover' => env('SAML2_DISCOVER', 'email'),
        'samldiscover' => env('SAML2_SAML_DISCOVER', 'http://schemas.xmlsoap.org/ws/2005/05/identity/claims/emailaddress'),
        'eloquent' => \Inside\Authentication\Models\User::class,
    ],
    'strict' => true,
    'debug' => env('APP_DEBUG', false),
    'proxyVars' => env('SAML2_PROXY_VARS', false),
    'sp' => [
        'NameIDFormat' => env('SAML2_SP_NAMEIDFORMAT', \OneLogin\Saml2\Constants::NAMEID_TRANSIENT),
        'x509cert' => env('SAML2_SP_X509', $cert),
        'privateKey' => env('SAML2_SP_PRIVATEKEY', $key),
        'entityId' => env('SAML2_SP_ENTITYID', ''),
        'assertionConsumerService' => [
            'url' => '',
            'binding' => 'urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST',
        ],
        'singleLogoutService' => [
            'url' => '',
        ],
        'forceHttps' => env('SAML2_SP_FORCE_HTTPS', false),
    ],
    'idp' => [
        'entityId' => env('SAML2_IDP_ENTITYID', $idp_host . '/saml2/idp/metadata.php'),
        'singleSignOnService' => [
            'url' => env('SAML2_IDP_SSO', $idp_host . '/saml2/idp/SSOService.php'),
        ],
        'singleLogoutService' => [
            'url' => env('SAML2_IDP_SLS', $idp_host . '/saml2/idp/SingleLogoutService.php'),
        ],
        'x509cert' => env('SAML2_IDP_X509', 'MIID / TCCAuWgAwIBAgIJAI4R3WyjjmB1MA0GCSqGSIb3DQEBCwUAMIGUMQswCQYDVQQGEwJBUjEVMBMGA1UECAwMQnVlbm9zIEFpcmVzMRUwEwYDVQQHDAxCdWVub3MgQWlyZXMxDDAKBgNVBAoMA1NJVTERMA8GA1UECwwIU2lzdGVtYXMxFDASBgNVBAMMC09yZy5TaXUuQ29tMSAwHgYJKoZIhvcNAQkBFhFhZG1pbmlAc2l1LmVkdS5hcjAeFw0xNDEyMDExNDM2MjVaFw0yNDExMzAxNDM2MjVaMIGUMQswCQYDVQQGEwJBUjEVMBMGA1UECAwMQnVlbm9zIEFpcmVzMRUwEwYDVQQHDAxCdWVub3MgQWlyZXMxDDAKBgNVBAoMA1NJVTERMA8GA1UECwwIU2lzdGVtYXMxFDASBgNVBAMMC09yZy5TaXUuQ29tMSAwHgYJKoZIhvcNAQkBFhFhZG1pbmlAc2l1LmVkdS5hcjCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAMbzW / EpEv + qqZzfT1Buwjg9nnNNVrxkCfuR9fQiQw2tSouS5X37W5h7RmchRt54wsm046PDKtbSz1NpZT2GkmHN37yALW2lY7MyVUC7itv9vDAUsFr0EfKIdCKgxCKjrzkZ5ImbNvjxf7eA77PPGJnQ / UwXY7W + cvLkirp0K5uWpDk + nac5W0JXOCFR1BpPUJRbz2jFIEHyChRt7nsJZH6ejzNqK9lABEC76htNy1Ll / D3tUoPaqo8VlKW3N3MZE0DB9O7g65DmZIIlFqkaMH3ALd8adodJtOvqfDU / A6SxuwMfwDYPjoucykGDu1etRZ7dF2gd + W + 1Pn7yizPT1q8CAwEAAaNQME4wHQYDVR0OBBYEFPsn8tUHN8XXf23ig5Qro3beP8BuMB8GA1UdIwQYMBaAFPsn8tUHN8XXf23ig5Qro3beP8BuMAwGA1UdEwQFMAMBAf8wDQYJKoZIhvcNAQELBQADggEBAGu60odWFiK + DkQekozGnlpNBQz5lQ / bwmOWdktnQj6HYXu43e7sh9oZWArLYHEOyMUekKQAxOK51vbTHzzw66BZU91 / nqvaOBfkJyZKGfluHbD0 / hfOl / D5kONqI9kyTu4wkLQcYGyuIi75CJs15uA03FSuULQdY / Liv + czS / XYDyvtSLnu43VuAQWN321PQNhuGueIaLJANb2C5qq5ilTBUw6PxY9Z + vtMjAjTJGKEkE / tQs7CvzLPKXX3KTD9lIILmX5yUC3dLgjVKi1KGDqNApYGOMtjr5eoxPQrqDBmyx3flcy0dQTdLXud3UjWVW3N0PYgJtw5yBsS74QTGD4 = '),
        'certFingerprint' => env('SAML2_IDP_X509_FINGERPRINT', 'SHA1 Fingerprint = C9:DE:5D:F6:10:99:B0:5A:12:B2:CC:7D:1D:F7:38:D6:58:D5:A2:95'),
        'certFingerprintAlgorithm' => env('SAML2_IDP_X509_SHA_VERSION', 'sha1'),
        'metadata' => env('SAML2_IDP_METADATA', setting('sso_config', 'saml_federation_metadata_url', '')),
        'binding' => env('SAML2_IDP_BINDING', 'urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST'),
        'cacheTime' => env('SAML2_IDP_METADATA_CACHE', 86400)
    ],
    'security' => [
        'nameIdEncrypted' => env('SAML2_SECURITY_NAMEID_ENCRYPTED', true),
        'authnRequestsSigned' => env('SAML2_SECURITY_AUTHN_REQUESTS_SIGNED', false),
        'logoutRequestSigned' => env('SAML2_SECURITY_LOGOUT_REQUEST_SIGNED', false),
        'logoutResponseSigned' => env('SAML2_SECURITY_LOGOUT_RESPONSE_SIGNED', false),
        'signMetadata' => env('SAML2_SECURITY_SIGN_METADATA', false),
        'wantNameId' => isset($settings['binding']['name_id_custom_attribute']),
        'wantMessagesSigned' => env('SAML2_SECURITY_WANT_MESSAGES_SIGNED', false),
        'wantAssertionsSigned' => env('SAML2_SECURITY_WANT_ASSERTIONS_SIGNED', false),
        'wantNameIdEncrypted' => env('SAML2_SECURITY_WANT_NAMEID_ENCRYPTED', false),
        'requestedAuthnContext' => env('SAML2_SECURITY_REQUESTED_AUTHN_CONTEXT', false),
    ],
    'contactPerson' => [
        'technical' => [
            'givenName' => 'Maecia',
            'emailAddress' => 'technique@maecia.com'
        ],
    ],
    'auto_provisioning' => env('SAML2_AUTO_PROVISIONING', false),
    'sync_attributes' => [ // Sync attributes for auto-provisioning
        // format is: userField => samlField
        // or: userField => function(Authenticator $authenticator, ContentBridge $bridge): mixed
        'name' => env('SAML2_SAML_DISCOVER'),
        'mail' => env('SAML2_SAML_DISCOVER'),
    ],
    'info_url' => env('SAML2_INFO_URL', null),
    'info_url_title' => env('SAML2_INFO_URL_TITLE', null),
];
