<?php

use Illuminate\Support\Facades\Route;

Route::group(
    [
        'prefix'    => 'saml',
        'namespace' => 'Inside\Authentication\SAML',
    ],
    function ($router) {
        // Login redirection page
        $router->get('login', ['as' => 'saml2.login', 'uses' => 'Http\Controllers\Saml2Controller@login']);
        $router->get(
            'logout',
            [
                'as'         => 'saml2.logout',
                'uses'       => 'Http\Controllers\Saml2Controller@logout',
                'middleware' => 'auth.api',
            ]
        );

        $router->get('metadata', ['as' => 'saml2.metadata', 'uses' => 'Http\Controllers\Saml2Controller@metadata']);
        $router->post('acs', ['as' => 'saml2.acs', 'uses' => 'Http\Controllers\Saml2Controller@acs']);
        $router->get('sls', ['as' => 'saml2.sls', 'uses' => 'Http\Controllers\Saml2Controller@sls']);
    }
);

Route::group([
    'prefix' => 'api/v1/admin/settings/saml',
    'namespace' => 'Inside\Authentication\SAML',
    'middleware' => ['auth.role:super_administrator'],
], function ($router) {
    $router->post('generate-keys', [
        'as' => 'saml2.config.generateKeys',
        'uses' => 'Http\Controllers\Saml2ConfigController@generateKeys',
    ]);
    $router->get('keys-exist', [
        'as' => 'saml2.config.keysExist',
        'uses' => 'Http\Controllers\Saml2ConfigController@keysExist',
    ]);
    $router->get('download-metadata', [
        'as' => 'saml2.config.downloadMetadata',
        'uses' => 'Http\Controllers\Saml2ConfigController@downloadMetadata',
    ]);
    $router->post('set-metadata', [
        'as' => 'saml2.config.setMetadata',
        'uses' => 'Http\Controllers\Saml2ConfigController@setMetadata',
    ]);
    $router->get('check-configuration', [
        'as' => 'saml2.config.check',
        'uses' => 'Http\Controllers\Saml2ConfigController@checkConfiguration',
    ]);
});
