<?php

namespace Inside\Authentication\SAML\Providers;

use Illuminate\Support\Arr;
use Inside\Support\EventServiceProvider;
use Inside\Authentication\SAML\SAML\AuthenticatorManager;

/**
 * Inside package authentication SAML service.
 *
 * @category Class
 * @package  Inside
 * @author   Maecia <technique@maecia.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://www.maecia.com/
 */
class InsideAuthenticationSAMLServiceProvider extends EventServiceProvider
{
    public function register(): void
    {
        $this->mergeConfigFrom(__DIR__.'/../../config/saml2.php', 'saml2');

        $this->app->singleton(
            AuthenticatorManager::class,
            function () {
                $manager = new AuthenticatorManager();

                $default = config('saml2');
                $authenticators = Arr::get($default, 'authenticators', []);
                Arr::forget($default, 'authenticators');

                if (empty($authenticators)) {
                    $manager->registerAuthenticator($default);
                }

                foreach ($authenticators as $name => $config) {
                    $authenticatorConfig = $default;

                    // Ici on tricks un peu, on veut remplacer les valeurs reécursivement,
                    // mais array_merge_recursive() ne remplace pas, il ajoute.
                    // Avec cette méthode on est sûr que tout est bien remplacé.

                    foreach (Arr::dot($config) as $key => $value) {
                        Arr::set($authenticatorConfig, $key, $value);
                    }

                    $manager->registerAuthenticator($authenticatorConfig, $name);
                }
                return $manager;
            }
        );
    }
}
