<?php

declare(strict_types=1);

namespace Inside\Authentication\Okta\Providers;

use Inside\Support\EventServiceProvider;
use Laravel\Socialite\Facades\Socialite;
use Laravel\Socialite\SocialiteServiceProvider;

final class InsideAuthenticationOktaServiceProvider extends EventServiceProvider
{
    public function register(): void
    {
        $this->mergeRecursiveConfigFrom(__DIR__.'/../../config/services.php', 'services');

        $this->app->register(SocialiteServiceProvider::class);
        $this->app->alias('Socialite', Socialite::class);
    }
}
