
  
# Inside Authentification OAuth2
# Process

:warning: 

- Users must be present in the database.
- The provider must comply with the OAuth2 standard ([RFC 6749](http://tools.ietf.org/html/rfc6749))

**Steps** : 

1. The user goes to the intranet, he is redirected by the *front* to *oauth2/login*.
2. The user is redirected to the Provider's login page <=> `OAUTH2_URL_AUTHORIZE`
3. The user connects and is redirected by the Provider to *oauth2/login* <=> `OAUTH2_REDIRECT_URI` with a GET `code` parameter in case of success.
4. This `authorization code` allows to obtain `an access token` by making an HTTP request to `OAUTH2_URL_ACCESS_TOKEN` with the `authorization code` in header (*Authorization: Bearer* `code).
5. Once the access token has been retrieved, an HTTP request is made to `OAUTH2_RESOURCE_OWNER_DETAILS` to retrieve the current user and extract his email.
6. If the email corresponds to a user of the intranet, a redirection is made with the user's `api_token` to the following URL: `/external-login/{API_TOKEN}`.

# Configuration

| Field| Description |
|------------|---------|
| OAUTH2_CLIENT_ID     | Client id assigned by the provider    |
| OAUTH2_CLIENT_SECRET     | Secret key assigned by the Provider  |
| OAUTH2_REDIRECT_URI | URL of redirection after login to the Provider    |
| OAUTH2_URL_AUTHORIZE | URL assigned by the provider for the login    |
| OAUTH2_URL_ACCESS_TOKEN | URL assigned by the provider to get an access token    |
| OAUTH2_RESOURCE_OWNER_DETAILS | URL assigned by the provider to get user data    |
| OAUTH2_USER_MAIL_FIELD | Email field (Provider side)    |

# Installation

 1. Edit your .env file to put the following lines :
 
```
    OAUTH2_CLIENT_ID={YOUR_CLIENT_ID}
    OAUTH2_CLIENT_SECRET={YOUR_CLIENT_SECRET}
    OAUTH2_REDIRECT_URI={YOUR_URI}
    OAUTH2_URL_AUTHORIZE={PROVIDER_URL_AUTHORIZE}
    OAUTH2_URL_ACCESS_TOKEN={PROVIDER_URL_ACCESS_TOKEN}
    OAUTH2_RESOURCE_OWNER_DETAILS={PROVIDER_URL_USER_DATA}
    OAUTH2_USER_MAIL_FIELD={EMAIL_FIELD}
```

**Note**: `OAUTH2_USER_MAIL_FIELD` can take an array with the following syntax (separate key/value by **point**) : *Key* **.** Key **.** *Value*

Example :

    OAUTH2_USER_MAIL_FIELD=otherMails.0
    
2. Edit *front/conf/conf.site.js* to add the following lines : 

```javascript
  externalLogin: JSON.stringify({
    type: 'oauth2',
    urls: {
      login: '/oauth2/login',
      logout: '/logout'
    }
  }), 
```
# OAuth2 Client of PHP League

This module is based on the OAuth2 Client of the PHP League, you can retrieve his documentation with the following link : 
 - [https://oauth2-client.thephpleague.com/](https://oauth2-client.thephpleague.com/)

