<?php

namespace Inside\Authentication\Ldap\Providers;

use Inside\Authentication\Ldap\Contracts\AuthenticationLdap;
use Inside\Authentication\Ldap\Services\AuthenticationLdapService;
use Inside\Support\EventServiceProvider;
use Psr\Container\ContainerExceptionInterface;
use Psr\Container\NotFoundExceptionInterface;

/**
 * Inside package authentication LDAP service.
 *
 * @category Class
 * @package  Inside
 * @author   Maecia <technique@maecia.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://www.maecia.com/
 */
class InsideAuthenticationLdapServiceProvider extends EventServiceProvider
{
    public array $bindings = [
        AuthenticationLdap::class => AuthenticationLdapService::class,
    ];

    public function register()
    {
        try {
            $this->mergeRecursiveConfigFrom(__DIR__.'/../../config/authorized.php', 'authorized');
            $this->mergeConfigTo(__DIR__.'/../../config/bind.php', 'bind');
        } catch (NotFoundExceptionInterface|ContainerExceptionInterface) {
        }
    }
}
