<?php

namespace Inside\Authentication\Google\Providers;

use Inside\Support\EventServiceProvider;
use Psr\Container\ContainerExceptionInterface;
use Psr\Container\NotFoundExceptionInterface;

/**
 * Inside package authentication Google service.
 *
 * @category Class
 * @package  Inside
 * @author   Maecia <technique@maecia.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://www.maecia.com/
 */
class InsideAuthenticationGoogleServiceProvider extends EventServiceProvider
{
    public function register(): void
    {
        try {
            $this->mergeRecursiveConfigFrom(__DIR__.'/../../config/services.php', 'services');
        } catch (NotFoundExceptionInterface|ContainerExceptionInterface) {
        }

        $this->app->register(\Laravel\Socialite\SocialiteServiceProvider::class);
        $this->app->alias('Socialite', \Laravel\Socialite\Facades\Socialite::class);
    }
}
