# Inside Authentication Google

For this module to work, the Google Plus and Google People APIs must be activated in the Google Developer Console.

Parameters to pass:

| Parameter            | Value                                          |
|----------------------|------------------------------------------------|
| GOOGLE_SERVER_KEY    | The Google API Key                             |
| GOOGLE_CLIENT_ID     | The Google client ID                           |
| GOOGLE_CLIENT_SECRET | The Google App Secret                          |
| GOOGLE_REDIRECT      | The redirect callback                          |
| GOOGLE_DOMAIN        | Optional, restrict the login on a given domain |

## Google Developer Console (client side)

The Google Plus and Google People APIs must be activated here:
https://console.developers.google.com/

Once the APIs are activated, several things must be created and set in the console (Idents tab):

- An API key
- An oAuth client ID with authorized Javascript origins:
    - https://[code].staging.maecia.com
    - The production URL once it is known
- The authorized redirect URLs:
    - https://[code].staging.maecia.com/google/login/callback
    - [production]/google/login/callback

## services.php

A `services.php` file must be created in the instance back repository with these values:

```php
<?php

return [
    'google' => [
        'client_id'     => env('GOOGLE_CLIENT_ID'),
        'client_secret' => env('GOOGLE_CLIENT_SECRET'),
        'redirect'      => env('GOOGLE_REDIRECT')
    ],
];
```
