<?php

use Illuminate\Support\Facades\Route;

Route::group(
    [
        'namespace'  => 'Inside\Archive\Http\Controllers',
        'prefix'     => 'api/v1',
        'middleware' => ['auth.backoffice.access:archive'],
    ],
    function ($router) {
        $router->get('archives', ['uses' => 'ArchiveController@list']);
        $router->post('archives/restore', ['uses' => 'ArchiveController@restore']);
        $router->delete('archives', ['uses' => 'ArchiveController@delete']);
    }
);
